import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class UserRecentlyViewedPatient extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static async create(data) {
        return super.upsert(data, {
            conflictFields: [
                'user_id',
                'patient_id'
            ]
        });
    }
}

//# sourceMappingURL=UserRecentlyViewedPatient.js.map