import { SYNC_DIRECTIONS } from '@tamanu/constants';
export const getModelsForDirections = (models, directions)=>{
    return Object.fromEntries(Object.entries(models).filter(([, model])=>directions.includes(model.syncDirection)));
};
export const getModelsForPull = (models)=>getModelsForDirections(models, [
        SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
        SYNC_DIRECTIONS.BIDIRECTIONAL
    ]);
export const getModelsForPush = (models)=>getModelsForDirections(models, [
        SYNC_DIRECTIONS.PUSH_TO_CENTRAL,
        SYNC_DIRECTIONS.PUSH_TO_CENTRAL_THEN_DELETE,
        SYNC_DIRECTIONS.BIDIRECTIONAL
    ]);

//# sourceMappingURL=getModelsForDirection.js.map