"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "BaseError", {
    enumerable: true,
    get: function() {
        return BaseError;
    }
});
const _constants = require("./constants");
let BaseError = class BaseError extends Error {
    name;
    type;
    title;
    status;
    detail;
    extraData = {};
    constructor(type, title, status, detail){
        super(detail ?? title);
        this.name = this.constructor.name;
        this.type = type;
        this.title = title;
        this.status = status;
        this.detail = detail;
    }
    withCause(error) {
        this.cause = error;
        return this;
    }
    withExtraData(extraData) {
        if (Object.keys(extraData).some((key)=>[
                ..._constants.WELL_KNOWN_PROBLEM_KEYS,
                'stack'
            ].includes(key))) {
            throw new Error('BUG: reserved extra data key');
        }
        Object.assign(this.extraData, extraData);
        return this;
    }
};

//# sourceMappingURL=BaseError.js.map