"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UpcomingVaccinationSchema", {
    enumerable: true,
    get: function() {
        return UpcomingVaccinationSchema;
    }
});
const _zod = require("zod");
const _referenceDataschema = require("./referenceData.schema");
const _scheduledVaccineschema = require("./scheduledVaccine.schema");
const _constants = require("@tamanu/constants");
const UpcomingVaccinationSchema = _zod.z.object({
    scheduledVaccine: _scheduledVaccineschema.ScheduledVaccineSchema,
    vaccine: _referenceDataschema.ReferenceDataSchema,
    dueDate: _zod.z.string(),
    daysTillDue: _zod.z.number(),
    status: _zod.z.enum(_constants.VACCINE_STATUS)
});

//# sourceMappingURL=upcomingVaccination.schema.js.map