"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    AREA_TYPE_TO_IMAGING_TYPE: function() {
        return AREA_TYPE_TO_IMAGING_TYPE;
    },
    IMAGING_AREA_TYPES: function() {
        return IMAGING_AREA_TYPES;
    },
    IMAGING_TABLE_STATUS_GROUPINGS: function() {
        return IMAGING_TABLE_STATUS_GROUPINGS;
    },
    IMAGING_TABLE_VERSIONS: function() {
        return IMAGING_TABLE_VERSIONS;
    },
    IMAGING_TYPES: function() {
        return IMAGING_TYPES;
    },
    IMAGING_TYPES_VALUES: function() {
        return IMAGING_TYPES_VALUES;
    },
    INVOICEABLE_IMAGING_REQUEST_STATUSES: function() {
        return INVOICEABLE_IMAGING_REQUEST_STATUSES;
    }
});
const _statuses = require("./statuses.js");
const IMAGING_AREA_TYPES = {
    ANGIOGRAM_IMAGING_AREA: 'angiogramImagingArea',
    COLONOSCOPY_IMAGING_AREA: 'colonoscopyImagingArea',
    CT_SCAN_IMAGING_AREA: 'ctScanImagingArea',
    ECG_IMAGING_AREA: 'ecgImagingArea',
    ECHOCARDIOGRAM_IMAGING_AREA: 'echocardiogramImagingArea',
    ENDOSCOPY_IMAGING_AREA: 'endoscopyImagingArea',
    FLUROSCOPY_IMAGING_AREA: 'fluroscopyImagingArea',
    HOLTER_MONITOR_IMAGING_AREA: 'holterMonitorImagingArea',
    ORTHOPANTOMOGRAPHY_IMAGING_AREA: 'orthopantomographyImagingArea',
    MRI_IMAGING_AREA: 'mriImagingArea',
    MAMMOGRAM_IMAGING_AREA: 'mammogramImagingArea',
    MAMMOGRAM_SCREEN_IMAGING_AREA: 'mammogramScreenImagingArea',
    MAMMOGRAM_DIAG_IMAGING_AREA: 'mammogramDiagImagingArea',
    STRESS_TEST_IMAGING_AREA: 'stressTestImagingArea',
    ULTRASOUND_IMAGING_AREA: 'ultrasoundImagingArea',
    VASCULAR_STUDY_IMAGING_AREA: 'vascularStudyImagingArea',
    X_RAY_IMAGING_AREA: 'xRayImagingArea'
};
const IMAGING_TYPES = {
    ANGIOGRAM: 'angiogram',
    COLONOSCOPY: 'colonoscopy',
    CT_SCAN: 'ctScan',
    ECG: 'ecg',
    ECHOCARDIOGRAM: 'echocardiogram',
    ENDOSCOPY: 'endoscopy',
    FLUROSCOPY: 'fluroscopy',
    HOLTER_MONITOR: 'holterMonitor',
    MAMMOGRAM: 'mammogram',
    MAMMOGRAM_SCREEN: 'mammogramScreen',
    MAMMOGRAM_DIAG: 'mammogramDiag',
    ORTHOPANTOMOGRAPHY: 'orthopantomography',
    MRI: 'mri',
    STRESS_TEST: 'stressTest',
    ULTRASOUND: 'ultrasound',
    VASCULAR_STUDY: 'vascularStudy',
    X_RAY: 'xRay'
};
const IMAGING_TYPES_VALUES = Object.values(IMAGING_TYPES);
const AREA_TYPE_TO_IMAGING_TYPE = {
    [IMAGING_AREA_TYPES.X_RAY_IMAGING_AREA]: IMAGING_TYPES.X_RAY,
    [IMAGING_AREA_TYPES.CT_SCAN_IMAGING_AREA]: IMAGING_TYPES.CT_SCAN,
    [IMAGING_AREA_TYPES.ORTHOPANTOMOGRAPHY_IMAGING_AREA]: IMAGING_TYPES.ORTHOPANTOMOGRAPHY,
    [IMAGING_AREA_TYPES.ULTRASOUND_IMAGING_AREA]: IMAGING_TYPES.ULTRASOUND,
    [IMAGING_AREA_TYPES.MRI_IMAGING_AREA]: IMAGING_TYPES.MRI,
    [IMAGING_AREA_TYPES.ECG_IMAGING_AREA]: IMAGING_TYPES.ECG,
    [IMAGING_AREA_TYPES.HOLTER_MONITOR_IMAGING_AREA]: IMAGING_TYPES.HOLTER_MONITOR,
    [IMAGING_AREA_TYPES.ECHOCARDIOGRAM_IMAGING_AREA]: IMAGING_TYPES.ECHOCARDIOGRAM,
    [IMAGING_AREA_TYPES.MAMMOGRAM_IMAGING_AREA]: IMAGING_TYPES.MAMMOGRAM,
    [IMAGING_AREA_TYPES.MAMMOGRAM_SCREEN_IMAGING_AREA]: IMAGING_TYPES.MAMMOGRAM_SCREEN,
    [IMAGING_AREA_TYPES.MAMMOGRAM_DIAG_IMAGING_AREA]: IMAGING_TYPES.MAMMOGRAM_DIAG,
    [IMAGING_AREA_TYPES.ENDOSCOPY_IMAGING_AREA]: IMAGING_TYPES.ENDOSCOPY,
    [IMAGING_AREA_TYPES.FLUROSCOPY_IMAGING_AREA]: IMAGING_TYPES.FLUROSCOPY,
    [IMAGING_AREA_TYPES.ANGIOGRAM_IMAGING_AREA]: IMAGING_TYPES.ANGIOGRAM,
    [IMAGING_AREA_TYPES.COLONOSCOPY_IMAGING_AREA]: IMAGING_TYPES.COLONOSCOPY,
    [IMAGING_AREA_TYPES.VASCULAR_STUDY_IMAGING_AREA]: IMAGING_TYPES.VASCULAR_STUDY,
    [IMAGING_AREA_TYPES.STRESS_TEST_IMAGING_AREA]: IMAGING_TYPES.STRESS_TEST
};
const IMAGING_TABLE_STATUS_GROUPINGS = {
    ACTIVE: [
        _statuses.IMAGING_REQUEST_STATUS_TYPES.PENDING,
        _statuses.IMAGING_REQUEST_STATUS_TYPES.IN_PROGRESS
    ],
    COMPLETED: [
        _statuses.IMAGING_REQUEST_STATUS_TYPES.COMPLETED
    ]
};
const IMAGING_TABLE_VERSIONS = Object.fromEntries(Object.keys(IMAGING_TABLE_STATUS_GROUPINGS).map((key)=>{
    const statuses = IMAGING_TABLE_STATUS_GROUPINGS[key];
    return [
        key,
        {
            memoryKey: statuses.join('-'),
            statuses
        }
    ];
}));
const INVOICEABLE_IMAGING_REQUEST_STATUSES = [
    _statuses.IMAGING_REQUEST_STATUS_TYPES.IN_PROGRESS,
    _statuses.IMAGING_REQUEST_STATUS_TYPES.COMPLETED
];

//# sourceMappingURL=imaging.js.map