"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'fhir',
    tableName: 'encounters'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        last_updated: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        status: {
            type: _sequelize.Sequelize.TEXT,
            allowNull: false
        },
        class: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        actual_period: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        subject: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        location: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ], {
        unique: true
    });
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1682563475794-fhirEncounter.js.map