"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function up(query) {
    await query.createTable('patient_program_registrations', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        date: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        registration_status: {
            allowNull: false,
            type: _sequelize.default.TEXT
        },
        patient_id: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        program_registry_id: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        clinical_status_id: {
            type: _sequelize.default.STRING
        },
        clinician_id: {
            type: _sequelize.default.STRING
        },
        registering_facility_id: {
            type: _sequelize.default.STRING
        },
        facility_id: {
            type: _sequelize.default.STRING
        },
        village_id: {
            type: _sequelize.default.STRING
        }
    });
}
async function down(query) {
    await query.dropTable('patient_program_registrations');
}

//# sourceMappingURL=1693279401767-addPatientProgramRegistryTable.js.map