"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.removeColumn('invoice_price_list_items', 'visibility_status');
    await query.addColumn('invoice_price_list_items', 'is_hidden', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false
    });
}
async function down(query) {
    await query.addColumn('invoice_price_list_items', 'visibility_status', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: false,
        defaultValue: 'current'
    });
    await query.removeColumn('invoice_price_list_items', 'is_hidden');
}

//# sourceMappingURL=1765142814817-updateInvoicePriceListItemColumns.js.map