export declare const equalsIfPresent: (ruleVal: string | undefined, inputVal: string | undefined) => boolean;
/**
 * @param condition - Age condition as:
 *   - number (exact age): 30
 *   - object: { min: 15, max: 64 } or { min: 65 } or { max: 14 }
 * @param dob - patient date of birth as ISO date string (e.g., "2010-10-15")
 */
export declare const matchesAgeIfPresent: (condition?: number | {
    min?: number;
    max?: number;
} | undefined, dob?: string | null) => boolean;
/**
 * Matches facility with exclusionary logic:
 * - If any price list specifies a facilityId, then price lists without a facilityId
 *   match all facilities EXCEPT those explicitly specified by other price lists
 * - If no price lists specify a facilityId, then all price lists match any facility
 */
export declare const matchesFacilityWithExclusionaryLogic: (ruleFacilityId: string | undefined, inputFacilityId: string | undefined, allRules: Array<Record<string, any>>) => boolean;
//# sourceMappingURL=invoicePriceListMatching.d.ts.map