import { ErrorType } from './constants';
/** Implementation of RFC 9457 Problem Details for HTTP APIs <https://datatracker.ietf.org/doc/html/rfc9457> */
export declare class Problem extends Error {
    type: ErrorType | string;
    title: string;
    status: number;
    detail?: string;
    extra: Map<string, any>;
    /** When the Problem has been obtained from an API call, this will typically have its Response object. */
    response?: Response;
    constructor(type: string, title: string, status?: number, detail?: string);
    withResponse(response: Response): Problem;
    static fromError(error: Error): Problem;
    get headers(): Record<string, string>;
    /** Mostly for test mocks, converts a Problem into a fetch Response. */
    intoResponse(): Response;
    excludeSensitiveFields(exclude: boolean): this;
    toJSON(): Record<string, any>;
    static fromJSON(json: Record<string, any>): Problem | null;
}
//# sourceMappingURL=Problem.d.ts.map