"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "deleteChartInstance", {
    enumerable: true,
    get: function() {
        return deleteChartInstance;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _ability = require("@casl/ability");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const deleteChartInstance = ()=>(0, _expressasynchandler.default)(async (req, res)=>{
        const { db, params, models } = req;
        const { chartInstanceResponseId } = params;
        const surveyResponse = await models.SurveyResponse.findByPk(chartInstanceResponseId);
        req.checkPermission('delete', (0, _ability.subject)('Charting', {
            id: surveyResponse?.surveyId
        }));
        // all answers will also be soft deleted automatically
        await db.transaction(async ()=>{
            await models.SurveyResponse.destroy({
                where: {
                    id: chartInstanceResponseId
                }
            });
            await models.SurveyResponse.destroy({
                where: {
                    'metadata.chartInstanceResponseId': chartInstanceResponseId
                }
            });
        });
        res.send({});
    });

//# sourceMappingURL=deleteChartInstance.js.map