"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "invoiceItemsRoute", {
    enumerable: true,
    get: function() {
        return invoiceItemsRoute;
    }
});
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const invoiceItemsRoute = (0, _crudHelpers.permissionCheckingRouter)('read', 'Invoice');
invoiceItemsRoute.get('/:id/items', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    const invoiceId = params.id;
    const invoice = await models.Invoice.findByPk(invoiceId);
    if (!invoice) {
        throw new Error(`Invoice not found: ${invoiceId}`);
    }
    const invoicePriceListId = await models.InvoicePriceList.getIdForPatientEncounter(invoice.encounterId);
    const associations = models.InvoiceItem.getListReferenceAssociations(models, invoicePriceListId);
    const response = await (0, _crudHelpers.getResourceList)(req, 'InvoiceItem', 'invoiceId', {
        skipPermissionCheck: true,
        include: associations
    });
    res.send(response);
}));

//# sourceMappingURL=invoiceItems.js.map