"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "AdministeredVaccineSchema", {
    enumerable: true,
    get: function() {
        return AdministeredVaccineSchema;
    }
});
const _zod = require("zod");
const _referenceDataschema = require("./referenceData.schema");
const _scheduledVaccineschema = require("./scheduledVaccine.schema");
const _userschema = require("./user.schema");
const _locationschema = require("./location.schema");
const _constants = require("@tamanu/constants");
const AdministeredVaccineSchema = _zod.z.object({
    id: _zod.z.string(),
    // Vaccine administration details
    batch: _zod.z.string().nullish(),
    status: _zod.z.enum(_constants.VACCINE_STATUS),
    date: _zod.z.string().nullish(),
    location: _locationschema.LocationSchema.nullish(),
    // Injection details
    injectionSite: _zod.z.enum(_constants.INJECTION_SITE_VALUES).nullish(),
    // Vaccine information
    vaccineBrand: _zod.z.string().nullish(),
    vaccineName: _zod.z.string().nullish(),
    disease: _zod.z.string().nullish(),
    // Administration details
    givenBy: _zod.z.string().nullish(),
    givenElsewhere: _zod.z.boolean().nullish(),
    // Consent information
    consent: _zod.z.boolean().nullish(),
    consentGivenBy: _zod.z.string().nullish(),
    // Reason for not giving (if applicable)
    reason: _zod.z.string().nullish(),
    // Related data
    scheduledVaccine: _scheduledVaccineschema.ScheduledVaccineSchema.nullish(),
    recorder: _userschema.UserSchema.nullish(),
    notGivenReason: _referenceDataschema.ReferenceDataSchema.nullish()
});

//# sourceMappingURL=administeredVaccine.schema.js.map