"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "IDCardPrintout", {
    enumerable: true,
    get: function() {
        return IDCardPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _patientAccessors = require("../patientAccessors");
const _jsbarcode = /*#__PURE__*/ _interop_require_default(require("jsbarcode"));
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const CustomBarcode = ({ id, width, height })=>{
    // eslint-disable-next-line no-undef
    const canvas = document.createElement('canvas');
    (0, _jsbarcode.default)(canvas, id, {
        width: 1,
        margin: 0,
        displayValue: false
    });
    const barcode = canvas.toDataURL();
    return /*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        source: barcode,
        style: {
            height,
            maxWidth: width,
            objectFit: 'cover'
        }
    });
};
const mmToPt = (mm)=>mm * 2.835;
const styles = _renderer.StyleSheet.create({
    mainContainer: {
        display: 'flex',
        flexDirection: 'row',
        height: '28.6mm',
        overflow: 'hidden'
    },
    photoContainer: {
        width: '1in',
        paddingHorizontal: '2mm',
        paddingTop: '1mm'
    },
    photoFrame: {
        width: '1in',
        height: '1.3in'
    },
    photo: {
        width: '100%',
        height: '100%',
        objectFit: 'cover'
    },
    details: {
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        marginLeft: '5mm'
    },
    infoRow: {
        display: 'flex',
        flexDirection: 'row',
        fontSize: '2.4mm',
        marginVertical: 1.8
    },
    detailsKey: {
        width: '18mm',
        fontWeight: 700
    },
    detailsValue: {
        maxWidth: '35mm',
        overflow: 'hidden',
        fontWeight: 700
    },
    barcodeRow: {
        height: '6.3mm',
        marginLeft: '29.4mm'
    }
});
const MainContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.mainContainer,
        ...props
    });
const PhotoContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.photoContainer,
        ...props
    });
const PhotoFrame = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.photoFrame,
        ...props
    });
const Details = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.details,
        ...props
    });
const InfoRow = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.infoRow,
        ...props
    });
const DetailsKey = (props)=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: styles.detailsKey,
        ...props
    });
const DetailsValue = (props)=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: styles.detailsValue,
        ...props
    });
const BarcodeRow = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.barcodeRow,
        ...props
    });
const DetailsRow = ({ value, label })=>/*#__PURE__*/ _react.default.createElement(InfoRow, null, /*#__PURE__*/ _react.default.createElement(DetailsKey, null, `${label}: `), /*#__PURE__*/ _react.default.createElement(DetailsValue, null, value));
const PatientPhoto = ({ patientImageData })=>{
    return /*#__PURE__*/ _react.default.createElement(PhotoContainer, null, /*#__PURE__*/ _react.default.createElement(PhotoFrame, null, /*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        src: `data:image/jpeg;base64,${patientImageData}`,
        style: styles.photo
    })));
};
const IDCardPrintoutComponent = ({ patient, patientImageData, cardDimensions, measures, getTranslation })=>{
    const pageStyles = _renderer.StyleSheet.create({
        card: {
            width: cardDimensions.width,
            height: cardDimensions.height,
            marginTop: mmToPt(measures.cardMarginTop),
            marginLeft: mmToPt(measures.cardMarginLeft),
            display: 'flex',
            flexDirection: 'column'
        }
    });
    const Card = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: pageStyles.card,
            ...props
        });
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: {
            paddingTop: mmToPt(10.6)
        }
    }, /*#__PURE__*/ _react.default.createElement(Card, null, /*#__PURE__*/ _react.default.createElement(MainContainer, null, /*#__PURE__*/ _react.default.createElement(PatientPhoto, {
        patientImageData: patientImageData
    }), /*#__PURE__*/ _react.default.createElement(Details, null, /*#__PURE__*/ _react.default.createElement(DetailsRow, {
        value: patient.displayId,
        label: getTranslation('general.localisedField.displayId.label.short', 'NHN')
    }), /*#__PURE__*/ _react.default.createElement(DetailsRow, {
        value: patient.lastName,
        label: getTranslation('general.localisedField.lastName.label', 'Last name')
    }), /*#__PURE__*/ _react.default.createElement(DetailsRow, {
        value: patient.firstName,
        label: getTranslation('general.localisedField.firstName.label', 'First name')
    }), /*#__PURE__*/ _react.default.createElement(DetailsRow, {
        value: (0, _patientAccessors.getDob)(patient, {
            getTranslation
        }),
        label: getTranslation('general.localisedField.dateOfBirth.label.short', 'DOB')
    }), /*#__PURE__*/ _react.default.createElement(DetailsRow, {
        value: (0, _patientAccessors.getSex)(patient),
        label: getTranslation('general.localisedField.sex.label', 'Sex')
    }))), /*#__PURE__*/ _react.default.createElement(BarcodeRow, null, /*#__PURE__*/ _react.default.createElement(CustomBarcode, {
        height: "5.9mm",
        width: "33mm",
        id: patient.displayId
    })))));
};
const IDCardPrintout = (0, _languageContext.withLanguageContext)(IDCardPrintoutComponent);

//# sourceMappingURL=IDCardPrintout.js.map