"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyMetroResolver = exports.resolveModulePath = exports.remapReactNativeModule = void 0;
const module_1 = require("@rnx-kit/tools-node/module");
const path_1 = require("@rnx-kit/tools-node/path");
const platform_1 = require("@rnx-kit/tools-react-native/platform");
const path = __importStar(require("path"));
const helper_1 = require("./helper");
const remapReactNativeModule = (_context, moduleName, platform) => {
    const platformImpl = (0, platform_1.getAvailablePlatforms)()[platform];
    if (platformImpl) {
        if (moduleName === "react-native") {
            return platformImpl;
        }
        else if (moduleName.startsWith("react-native/")) {
            return `${platformImpl}/${moduleName.slice("react-native/".length)}`;
        }
    }
    return moduleName;
};
exports.remapReactNativeModule = remapReactNativeModule;
const resolveModulePath = ({ extraNodeModules, originModulePath }, moduleName, _platform) => {
    var _a;
    // Performance: Assume relative links are not going to hit symlinks
    const ref = (0, module_1.parseModuleRef)(moduleName);
    if ((0, module_1.isFileModuleRef)(ref)) {
        return moduleName;
    }
    const pkgName = ref.scope ? `${ref.scope}/${ref.name}` : ref.name;
    const pkgRoot = (_a = extraNodeModules === null || extraNodeModules === void 0 ? void 0 : extraNodeModules[pkgName]) !== null && _a !== void 0 ? _a : (0, helper_1.resolveFrom)(pkgName, originModulePath);
    if (!pkgRoot) {
        return moduleName;
    }
    const replaced = moduleName.replace(pkgName, pkgRoot);
    const relativePath = path.relative(path.dirname(originModulePath), replaced);
    return relativePath.startsWith(".")
        ? relativePath
        : `.${path.sep}${relativePath}`;
};
exports.resolveModulePath = resolveModulePath;
function applyMetroResolver(resolve, ctx, moduleName, platform) {
    // Resolve redirects before we try to resolve the module:
    // https://github.com/facebook/metro/blob/v0.76.7/docs/Resolution.md#redirectmodulepath-string--string--false
    const realModuleName = ctx.redirectModulePath(moduleName);
    if (realModuleName === false) {
        return { type: "empty" };
    }
    const modifiedModuleName = (0, exports.resolveModulePath)(ctx, realModuleName, platform);
    // @ts-expect-error We pass 4 arguments instead of 3 to be backwards compatible
    return resolve(ctx, (0, path_1.normalizePath)(modifiedModuleName), platform, null);
}
exports.applyMetroResolver = applyMetroResolver;
//# sourceMappingURL=resolver.js.map