import type { PackageRef } from "./package";
/**
 * Module reference relative to a package, such as `react-native` or
 * `@rnx-kit/tools/node/index`.
 */
export type PackageModuleRef = PackageRef & {
    path?: string;
};
/**
 * Module reference rooted to a file system location, either relative
 * to a directory, or as an absolute path. For example, `./index` or
 * `/repos/rnx-kit/packages/tools/src/index`.
 */
export type FileModuleRef = {
    path: string;
};
/**
 * Parse a module reference into either a package module reference or a file
 * module reference.
 *
 * @param moduleRef Module reference
 * @return Module components
 */
export declare function parseModuleRef(r: string): PackageModuleRef | FileModuleRef;
/**
 * Is the module reference a package module reference?
 *
 * @param r Module reference
 * @returns `true` if the module reference is based on a package
 */
export declare function isPackageModuleRef(r: PackageModuleRef | FileModuleRef): r is PackageModuleRef;
/**
 * Is the module reference relative to a file location?
 *
 * @param r Module reference
 * @returns `true` if the module reference is based on a file location
 */
export declare function isFileModuleRef(r: PackageModuleRef | FileModuleRef): r is FileModuleRef;
/**
 * Convert a module path to a package module reference.
 *
 * Find the module's `package.json` file, read the package name/scope, and
 * assemble that along with the module's path into a complete reference.
 *
 * @param modulePath Path to the module. Must be within a package.
 * @returns A package module reference, or `undefined` on failure
 */
export declare function getPackageModuleRefFromModulePath(modulePath: string): PackageModuleRef | undefined;
//# sourceMappingURL=module.d.ts.map