import BaseSchema from './schema';
import { boolean as locale } from './locale';
import isAbsent from './util/isAbsent';
export function create() {
  return new BooleanSchema();
}
export default class BooleanSchema extends BaseSchema {
  constructor() {
    super({
      type: 'boolean'
    });
    this.withMutation(() => {
      this.transform(function (value) {
        if (!this.isType(value)) {
          if (/^(true|1)$/i.test(String(value))) return true;
          if (/^(false|0)$/i.test(String(value))) return false;
        }

        return value;
      });
    });
  }

  _typeCheck(v) {
    if (v instanceof Boolean) v = v.valueOf();
    return typeof v === 'boolean';
  }

  isTrue(message = locale.isValue) {
    return this.test({
      message,
      name: 'is-value',
      exclusive: true,
      params: {
        value: 'true'
      },

      test(value) {
        return isAbsent(value) || value === true;
      }

    });
  }

  isFalse(message = locale.isValue) {
    return this.test({
      message,
      name: 'is-value',
      exclusive: true,
      params: {
        value: 'false'
      },

      test(value) {
        return isAbsent(value) || value === false;
      }

    });
  }

}
create.prototype = BooleanSchema.prototype;