"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InterceptorManager", {
    enumerable: true,
    get: function() {
        return InterceptorManager;
    }
});
const _lodash = require("lodash");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let InterceptorManager = class InterceptorManager {
    /**
   * Add a new interceptor to the stack
   *
   * @param fulfilled The function to handle `then` for a `Promise`
   * @param rejected The function to handle `reject` for a `Promise`
   *
   * @return An ID used to remove interceptor later
   */ use(fulfilled, rejected) {
        this.handlers.push({
            fulfilled,
            rejected
        });
        return this.handlers.length - 1;
    }
    /**
   * Remove an interceptor from the stack
   *
   * @param id The ID that was returned by `use`
   *
   * @returns `true` if the interceptor was removed, `false` otherwise
   */ eject(id) {
        if (this.handlers[id]) {
            this.handlers[id] = null;
        }
    }
    /**
   * Clear all interceptors from the stack
   *
   * @returns void
   */ clear() {
        if (this.handlers) {
            this.handlers = [];
        }
    }
    /**
   * Iterate over all the registered interceptors
   *
   * This method is particularly useful for skipping over any
   * interceptors that may have become `null` calling `eject`.
   *
   * @param fn The function to call for each interceptor
   *
   * @returns void
   */ forEach(fn) {
        (0, _lodash.forEach)(this.handlers, function forEachHandler(h) {
            if (h !== null) {
                fn(h);
            }
        });
    }
    constructor(){
        _define_property(this, "handlers", void 0);
        this.handlers = [];
    }
};

//# sourceMappingURL=InterceptorManager.js.map