"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    AUTOMATIC_INVOICE_CREATION_EXCLUDED_ENCOUNTER_TYPES: function() {
        return AUTOMATIC_INVOICE_CREATION_EXCLUDED_ENCOUNTER_TYPES;
    },
    INVOICE_INSURER_PAYMENT_STATUSES: function() {
        return INVOICE_INSURER_PAYMENT_STATUSES;
    },
    INVOICE_INSURER_PAYMENT_STATUS_LABELS: function() {
        return INVOICE_INSURER_PAYMENT_STATUS_LABELS;
    },
    INVOICE_ITEMS_CATEGORIES: function() {
        return INVOICE_ITEMS_CATEGORIES;
    },
    INVOICE_ITEMS_CATEGORIES_MODELS: function() {
        return INVOICE_ITEMS_CATEGORIES_MODELS;
    },
    INVOICE_ITEMS_CATEGORY_LABELS: function() {
        return INVOICE_ITEMS_CATEGORY_LABELS;
    },
    INVOICE_ITEMS_DISCOUNT_TYPES: function() {
        return INVOICE_ITEMS_DISCOUNT_TYPES;
    },
    INVOICE_PATIENT_PAYMENT_STATUSES: function() {
        return INVOICE_PATIENT_PAYMENT_STATUSES;
    },
    INVOICE_PATIENT_PAYMENT_STATUSES_LABELS: function() {
        return INVOICE_PATIENT_PAYMENT_STATUSES_LABELS;
    },
    INVOICE_PAYMENT_STATUSES: function() {
        return INVOICE_PAYMENT_STATUSES;
    },
    INVOICE_PRICE_LIST_ITEM_IMPORT_VALUES: function() {
        return INVOICE_PRICE_LIST_ITEM_IMPORT_VALUES;
    },
    INVOICE_PRODUCT_REFERENCE_DATA_TYPE_CATEGORIES: function() {
        return INVOICE_PRODUCT_REFERENCE_DATA_TYPE_CATEGORIES;
    },
    INVOICE_STATUSES: function() {
        return INVOICE_STATUSES;
    },
    INVOICE_STATUS_LABELS: function() {
        return INVOICE_STATUS_LABELS;
    }
});
const _encounters = require("./encounters");
const _imaging = require("./imaging");
const _importable = require("./importable");
const INVOICE_STATUSES = {
    CANCELLED: 'cancelled',
    IN_PROGRESS: 'in_progress',
    FINALISED: 'finalised'
};
const INVOICE_STATUS_LABELS = {
    [INVOICE_STATUSES.CANCELLED]: 'Cancelled',
    [INVOICE_STATUSES.IN_PROGRESS]: 'In progress',
    [INVOICE_STATUSES.FINALISED]: 'Finalised'
};
const INVOICE_PAYMENT_STATUSES = {
    UNPAID: 'unpaid',
    PAID: 'paid',
    PARTIAL: 'partial',
    REJECTED: 'rejected',
    PAID_REJECTED: 'paid/rejected'
};
const INVOICE_ITEMS_CATEGORIES = {
    PROCEDURE_TYPE: 'ProcedureType',
    IMAGING_TYPE: 'ImagingType',
    IMAGING_AREA: 'ImagingArea',
    DRUG: 'Drug',
    LAB_TEST_TYPE: 'LabTestType',
    LAB_TEST_PANEL: 'LabTestPanel'
};
const INVOICE_PRODUCT_REFERENCE_DATA_TYPE_CATEGORIES = {
    [_importable.REFERENCE_TYPES.PROCEDURE_TYPE]: INVOICE_ITEMS_CATEGORIES.PROCEDURE_TYPE,
    [_importable.REFERENCE_TYPES.IMAGING_TYPE]: INVOICE_ITEMS_CATEGORIES.IMAGING_TYPE,
    [_importable.REFERENCE_TYPES.DRUG]: INVOICE_ITEMS_CATEGORIES.DRUG
};
// All imaging area reference data types are mapped to the ImagingArea category
for (const areaType of Object.values(_imaging.IMAGING_AREA_TYPES)){
    INVOICE_PRODUCT_REFERENCE_DATA_TYPE_CATEGORIES[areaType] = INVOICE_ITEMS_CATEGORIES.IMAGING_AREA;
}
const INVOICE_ITEMS_CATEGORIES_MODELS = {
    [INVOICE_ITEMS_CATEGORIES.PROCEDURE_TYPE]: 'ReferenceData',
    [INVOICE_ITEMS_CATEGORIES.IMAGING_TYPE]: 'ReferenceData',
    [INVOICE_ITEMS_CATEGORIES.IMAGING_AREA]: 'ReferenceData',
    [INVOICE_ITEMS_CATEGORIES.DRUG]: 'ReferenceData',
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_TYPE]: 'LabTestType',
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_PANEL]: 'LabTestPanel'
};
const INVOICE_ITEMS_CATEGORY_LABELS = {
    [INVOICE_ITEMS_CATEGORIES.PROCEDURE_TYPE]: 'Procedure type',
    [INVOICE_ITEMS_CATEGORIES.IMAGING_TYPE]: 'Imaging type',
    [INVOICE_ITEMS_CATEGORIES.IMAGING_AREA]: 'Imaging area',
    [INVOICE_ITEMS_CATEGORIES.DRUG]: 'Drug',
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_TYPE]: 'Lab test type',
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_PANEL]: 'Lab test panel'
};
const INVOICE_ITEMS_DISCOUNT_TYPES = {
    PERCENTAGE: 'percentage',
    AMOUNT: 'amount'
};
const INVOICE_PATIENT_PAYMENT_STATUSES = {
    UNPAID: 'unpaid',
    PAID: 'paid',
    PARTIAL: 'partial'
};
const INVOICE_INSURER_PAYMENT_STATUSES = {
    UNPAID: 'unpaid',
    PAID: 'paid',
    PARTIAL: 'partial',
    REJECTED: 'rejected'
};
const INVOICE_PATIENT_PAYMENT_STATUSES_LABELS = {
    [INVOICE_PATIENT_PAYMENT_STATUSES.UNPAID]: 'Unpaid',
    [INVOICE_PATIENT_PAYMENT_STATUSES.PAID]: 'Paid',
    [INVOICE_PATIENT_PAYMENT_STATUSES.PARTIAL]: 'Partial'
};
const INVOICE_INSURER_PAYMENT_STATUS_LABELS = {
    [INVOICE_INSURER_PAYMENT_STATUSES.UNPAID]: 'Unpaid',
    [INVOICE_INSURER_PAYMENT_STATUSES.PAID]: 'Paid',
    [INVOICE_INSURER_PAYMENT_STATUSES.PARTIAL]: 'Partial',
    [INVOICE_INSURER_PAYMENT_STATUSES.REJECTED]: 'Rejected'
};
const INVOICE_PRICE_LIST_ITEM_IMPORT_VALUES = {
    HIDDEN: 'hidden'
};
const AUTOMATIC_INVOICE_CREATION_EXCLUDED_ENCOUNTER_TYPES = [
    _encounters.ENCOUNTER_TYPES.SURVEY_RESPONSE,
    _encounters.ENCOUNTER_TYPES.VACCINATION
];

//# sourceMappingURL=invoices.js.map