"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    NON_EDITABLE_NOTE_TYPES: function() {
        return NON_EDITABLE_NOTE_TYPES;
    },
    NOTE_PERMISSION_TYPES: function() {
        return NOTE_PERMISSION_TYPES;
    },
    NOTE_RECORD_TYPES: function() {
        return NOTE_RECORD_TYPES;
    },
    NOTE_RECORD_TYPE_VALUES: function() {
        return NOTE_RECORD_TYPE_VALUES;
    },
    NOTE_TYPES: function() {
        return NOTE_TYPES;
    },
    NOTE_TYPE_VALUES: function() {
        return NOTE_TYPE_VALUES;
    }
});
const NOTE_RECORD_TYPES = {
    ENCOUNTER: 'Encounter',
    PATIENT: 'Patient',
    TRIAGE: 'Triage',
    PATIENT_CARE_PLAN: 'PatientCarePlan',
    LAB_REQUEST: 'LabRequest',
    IMAGING_REQUEST: 'ImagingRequest'
};
const NOTE_TYPES = {
    TREATMENT_PLAN: 'notetype-treatmentPlan',
    DISCHARGE: 'notetype-discharge',
    AREA_TO_BE_IMAGED: 'notetype-areaToBeImaged',
    RESULT_DESCRIPTION: 'notetype-resultDescription',
    SYSTEM: 'notetype-system',
    OTHER: 'notetype-other',
    CLINICAL_MOBILE: 'notetype-clinicalMobile',
    HANDOVER: 'notetype-handover'
};
const NON_EDITABLE_NOTE_TYPES = [
    NOTE_TYPES.SYSTEM,
    NOTE_TYPES.CLINICAL_MOBILE
];
const NOTE_PERMISSION_TYPES = {
    OTHER_PRACTITIONER_ENCOUNTER_NOTE: 'OtherPractitionerEncounterNote',
    TREATMENT_PLAN_NOTE: 'TreatmentPlanNote'
};
const NOTE_RECORD_TYPE_VALUES = Object.values(NOTE_RECORD_TYPES);
const NOTE_TYPE_VALUES = Object.values(NOTE_TYPES);

//# sourceMappingURL=notes.js.map