"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CURRENTLY_AT_TYPES: function() {
        return CURRENTLY_AT_TYPES;
    },
    DEPRECATED_PRCC_LABELS: function() {
        return DEPRECATED_PRCC_LABELS;
    },
    PROGRAM_REGISTRATION_STATUS_LABELS: function() {
        return PROGRAM_REGISTRATION_STATUS_LABELS;
    },
    PROGRAM_REGISTRY_CONDITION_CATEGORIES: function() {
        return PROGRAM_REGISTRY_CONDITION_CATEGORIES;
    },
    PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS: function() {
        return PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS;
    },
    REGISTRATION_STATUSES: function() {
        return REGISTRATION_STATUSES;
    },
    STATUS_COLOR: function() {
        return STATUS_COLOR;
    }
});
const _colors = require("./colors.js");
const CURRENTLY_AT_TYPES = {
    VILLAGE: 'village',
    FACILITY: 'facility'
};
const REGISTRATION_STATUSES = {
    ACTIVE: 'active',
    INACTIVE: 'inactive',
    RECORDED_IN_ERROR: 'recordedInError'
};
const PROGRAM_REGISTRATION_STATUS_LABELS = {
    [REGISTRATION_STATUSES.ACTIVE]: 'Active',
    [REGISTRATION_STATUSES.INACTIVE]: 'Removed',
    [REGISTRATION_STATUSES.RECORDED_IN_ERROR]: 'Delete'
};
const STATUS_COLOR = {
    purple: _colors.COLORS.purple,
    pink: _colors.COLORS.pink,
    orange: _colors.COLORS.darkOrange,
    yellow: _colors.COLORS.metallicYellow,
    blue: _colors.COLORS.blue,
    green: _colors.COLORS.green,
    grey: _colors.COLORS.grey,
    red: _colors.COLORS.red,
    brown: '#7A492E',
    teal: '#125E7E'
};
const PROGRAM_REGISTRY_CONDITION_CATEGORIES = {
    UNKNOWN: 'unknown',
    DISPROVEN: 'disproven',
    RESOLVED: 'resolved',
    RECORDED_IN_ERROR: 'recordedInError'
};
const PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS = {
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.UNKNOWN]: 'Unknown',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.DISPROVEN]: 'Disproven',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.RESOLVED]: 'Resolved',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.RECORDED_IN_ERROR]: 'Recorded in error'
};
const DEPRECATED_PRCC_LABELS = {
    suspected: 'Suspected',
    underInvestigation: 'Under investigation',
    confirmed: 'Confirmed',
    unknown: 'Unknown',
    disproven: 'Disproven',
    resolved: 'Resolved',
    inRemission: 'In remission',
    notApplicable: 'Not applicable',
    recordedInError: 'Recorded in error'
}; // ########################################################################################################

//# sourceMappingURL=programRegistry.js.map