"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    WS_EVENTS: function() {
        return WS_EVENTS;
    },
    WS_EVENT_NAMESPACES: function() {
        return WS_EVENT_NAMESPACES;
    },
    WS_PATH: function() {
        return WS_PATH;
    }
});
const WS_PATH = '/api/socket.io/';
const WS_EVENT_NAMESPACES = {
    TELEGRAM: 'telegram',
    PATIENT_CONTACT: 'patient-contact',
    DATABASE: 'database',
    CLINICIAN_DASHBOARD: 'clinician-dashboard'
};
const { TELEGRAM, PATIENT_CONTACT, DATABASE, CLINICIAN_DASHBOARD } = WS_EVENT_NAMESPACES;
const WS_EVENTS = {
    TELEGRAM_SUBSCRIBE: `${TELEGRAM}:subscribe`,
    TELEGRAM_SUBSCRIBE_SUCCESS: `${TELEGRAM}:subscribe:success`,
    TELEGRAM_GET_BOT_INFO: `${TELEGRAM}:get-bot-info`,
    TELEGRAM_BOT_INFO: `${TELEGRAM}:bot-info`,
    PATIENT_CONTACT_INSERT: `${PATIENT_CONTACT}:insert`,
    TELEGRAM_UNSUBSCRIBE: `${TELEGRAM}:unsubscribe`,
    TELEGRAM_UNSUBSCRIBE_SUCCESS: `${TELEGRAM}:unsubscribe:success`,
    DATABASE_TABLE_CHANGED: `${DATABASE}:table-changed`,
    DATABASE_MATERIALIZED_VIEW_REFRESHED: `${DATABASE}:materialized-view-refreshed`,
    CLINICIAN_DASHBOARD_TASKS_UPDATE: `${CLINICIAN_DASHBOARD}:tasks-update`,
    CLINICIAN_BOOKINGS_UPDATE: `${CLINICIAN_DASHBOARD}:bookings-update`,
    CLINICIAN_APPOINTMENTS_UPDATE: `${CLINICIAN_DASHBOARD}:appointments-update`
};

//# sourceMappingURL=webSocket.js.map