"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createDummyEncounter: function() {
        return createDummyEncounter;
    },
    createDummyEncounterDiagnosis: function() {
        return createDummyEncounterDiagnosis;
    },
    createDummyPatient: function() {
        return createDummyPatient;
    },
    createDummyPatientAdditionalData: function() {
        return createDummyPatientAdditionalData;
    },
    createDummyPrescription: function() {
        return createDummyPrescription;
    },
    createDummyTriage: function() {
        return createDummyTriage;
    },
    randomReferenceData: function() {
        return randomReferenceData;
    },
    randomReferenceDataObjects: function() {
        return randomReferenceDataObjects;
    },
    randomReferenceId: function() {
        return randomReferenceId;
    },
    randomReferenceIds: function() {
        return randomReferenceIds;
    },
    randomUser: function() {
        return randomUser;
    },
    randomVitals: function() {
        return randomVitals;
    }
});
const _chance = /*#__PURE__*/ _interop_require_default(require("chance"));
const _datefns = require("date-fns");
const _constants = require("@tamanu/constants");
const _generateId = require("@tamanu/utils/generateId");
const _utilities = require("./utilities");
const _dateTime = require("@tamanu/utils/dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const { HOUR } = _utilities.TIME_INTERVALS;
const chance = new _chance.default();
async function randomUser(models) {
    return (0, _utilities.randomRecordId)(models, 'User');
}
async function randomReferenceId(models, type) {
    const obj = await models.ReferenceData.findOne({
        where: {
            type
        },
        order: models.ReferenceData.sequelize.random()
    });
    return obj.id;
}
async function randomReferenceIds(models, type, count) {
    const items = await models.ReferenceData.findAll({
        where: {
            type
        },
        order: models.ReferenceData.sequelize.random(),
        limit: count
    });
    return items.map((i)=>i.id);
}
async function randomReferenceData(models, type) {
    const obj = await models.ReferenceData.findOne({
        where: {
            type
        },
        order: models.ReferenceData.sequelize.random()
    });
    return obj;
}
async function randomReferenceDataObjects(models, type, count) {
    const objects = await models.ReferenceData.findAll({
        where: {
            type
        },
        order: models.ReferenceData.sequelize.random(),
        limit: count
    });
    return objects;
}
function randomVitals(overrides) {
    return {
        dateRecorded: (0, _dateTime.toDateTimeString)((0, _utilities.randomDate)()),
        weight: chance.floating({
            min: 60,
            max: 150
        }),
        height: chance.floating({
            min: 130,
            max: 190
        }),
        sbp: chance.floating({
            min: 115,
            max: 125
        }),
        dbp: chance.floating({
            min: 75,
            max: 85
        }),
        temperature: chance.floating({
            min: 36,
            max: 38
        }),
        heartRate: chance.floating({
            min: 40,
            max: 140
        }),
        respiratoryRate: chance.floating({
            min: 10,
            max: 18
        }),
        ...overrides
    };
}
async function createDummyTriage(models, overrides) {
    const arrivalTime = (0, _datefns.subMinutes)(new Date(), chance.integer({
        min: 2,
        max: 80
    }));
    return {
        score: chance.integer({
            min: 1,
            max: 5
        }),
        notes: chance.sentence(),
        arrivalTime,
        triageTime: arrivalTime,
        closedTime: null,
        chiefComplaintId: await randomReferenceId(models, 'triageReason'),
        secondaryComplaintId: chance.bool() ? null : await randomReferenceId(models, 'triageReason'),
        locationId: await (0, _utilities.randomRecordId)(models, 'Location'),
        practitionerId: await randomUser(models),
        ...overrides
    };
}
async function createDummyEncounter(models, { current, ...overrides } = {}) {
    const endDate = current ? (0, _dateTime.getCurrentDateTimeString)() : (0, _dateTime.toDateTimeString)((0, _utilities.randomDate)());
    const duration = chance.natural({
        min: HOUR,
        max: HOUR * 10
    });
    const startDate = (0, _dateTime.toDateTimeString)(new Date(new Date(endDate).getTime() - duration));
    return {
        encounterType: chance.pickone(Object.values(_constants.ENCOUNTER_TYPES)),
        startDate,
        endDate: current ? undefined : endDate,
        reasonForEncounter: chance.sentence({
            words: chance.integer({
                min: 4,
                max: 8
            })
        }),
        locationId: await (0, _utilities.randomRecordId)(models, 'Location'),
        departmentId: await (0, _utilities.randomRecordId)(models, 'Department'),
        examinerId: await randomUser(models),
        ...overrides
    };
}
function createDummyPatient(models, overrides = {}) {
    const gender = overrides.sex || chance.pickone([
        'male',
        'female'
    ]);
    const title = overrides.title || chance.pickone([
        'Mr',
        'Mrs',
        'Ms'
    ]);
    return {
        displayId: (0, _generateId.generateId)(),
        firstName: chance.first({
            gender
        }),
        lastName: chance.last(),
        culturalName: chance.last(),
        sex: chance.bool({
            likelihood: 5
        }) ? 'other' : gender,
        dateOfBirth: (0, _dateTime.toDateString)(chance.birthday()),
        title,
        ...overrides
    };
}
const randomDigits = (length)=>chance.string({
        length,
        pool: '0123456789'
    });
function randomPhoneNumber() {
    return `04${randomDigits(2)} ${randomDigits(3)} ${randomDigits(3)}`;
}
function createDummyPatientAdditionalData() {
    return {
        placeOfBirth: chance.city(),
        bloodType: chance.pickone([
            'A+',
            'B+',
            'A-',
            'B-',
            'AB+',
            'AB-',
            'O+',
            'O-'
        ]),
        primaryContactNumber: randomPhoneNumber(),
        secondaryContactNumber: randomPhoneNumber(),
        maritalStatus: chance.pickone([
            'Single',
            'Married',
            'Defacto'
        ]),
        cityTown: chance.city(),
        streetVillage: `${Math.floor(Math.random() * 200)} ${chance.street({
            short_suffix: true
        })}`,
        drivingLicense: randomDigits(10),
        passport: randomDigits(10)
    };
}
async function createDummyEncounterDiagnosis(models, overrides = {}) {
    const duration = chance.natural({
        min: HOUR,
        max: HOUR * 10
    });
    const date = (0, _dateTime.toDateTimeString)(new Date(new Date().getTime() - duration));
    return {
        date,
        certainty: chance.pickone([
            'suspected',
            'confirmed'
        ]),
        isPrimary: chance.bool(),
        diagnosisId: await randomReferenceId(models, 'diagnosis'),
        ...overrides
    };
}
async function createDummyPrescription(models, overrides = {}) {
    return {
        date: (0, _dateTime.getCurrentDateTimeString)(),
        startDate: (0, _dateTime.getCurrentDateTimeString)(),
        endDate: (0, _dateTime.toDateTimeString)((0, _datefns.addHours)(new Date(), 1)),
        note: chance.sentence({
            words: chance.integer({
                min: 4,
                max: 8
            })
        }),
        indication: chance.sentence({
            words: chance.integer({
                min: 4,
                max: 8
            })
        }),
        route: chance.word(),
        quantity: chance.integer({
            min: 0,
            max: 3
        }),
        repeats: 0,
        prescriberId: await randomUser(models),
        medicationId: await randomReferenceId(models, 'drug'),
        doseAmount: 1,
        units: chance.word(),
        frequency: chance.word(),
        ...overrides
    };
}

//# sourceMappingURL=patients.js.map