"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        // missing columns to add
        await query.addColumn('lab_requests', 'note', {
            type: Sequelize.STRING
        });
        // extra columns to remove
        await query.removeColumn('encounters', 'type');
    },
    down: async (query)=>{
        await query.removeColumn('lab_requests', 'note');
        await query.addColumn('encounters', 'type', {
            type: Sequelize.ENUM([
                'issue',
                'warning'
            ])
        });
    }
};

//# sourceMappingURL=004_missedColumns.js.map