"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.addColumn('patients', 'date_of_death', {
            type: Sequelize.DATE,
            allowNull: true
        });
        await query.addIndex('patients', {
            fields: [
                'date_of_death'
            ]
        });
    },
    down: async (query)=>{
        await query.removeIndex('patients', [
            'date_of_death'
        ]);
        await query.removeColumn('patients', 'date_of_death');
    }
};

//# sourceMappingURL=060_addDeathToPatient.js.map