"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.addColumn('patient_death_data', 'primary_cause_id', {
            type: Sequelize.STRING,
            references: {
                model: 'death_causes',
                key: 'id'
            },
            allowNull: true
        });
        await query.addColumn('patient_death_data', 'secondary_cause_id', {
            type: Sequelize.STRING,
            references: {
                model: 'death_causes',
                key: 'id'
            },
            allowNull: true
        });
    },
    down: async (query)=>{
        await query.removeColumn('patient_death_data', 'primary_cause_id');
        await query.removeColumn('patient_death_data', 'secondary_cause_id');
    }
};

//# sourceMappingURL=063_addPatientDeathDataCausesFields.js.map