"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const tables = [
    'departments',
    'facilities',
    'locations',
    'reference_data',
    'lab_test_types',
    'scheduled_vaccines'
];
async function up(query) {
    for (const table of tables){
        await query.addColumn(table, 'visibility_status', {
            type: _sequelize.default.TEXT,
            defaultValue: 'current'
        });
    }
}
async function down(query) {
    for (const table of tables){
        await query.removeColumn(table, 'visibility_status');
    }
}

//# sourceMappingURL=079_addVisibilityStatus.js.map