"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('patient_birth_data', {
        id: {
            type: _sequelize.default.STRING,
            defaultValue: _sequelize.default.UUIDV4,
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        patient_id: {
            type: _sequelize.default.STRING,
            allowNull: false,
            references: {
                model: 'patients',
                key: 'id'
            },
            unique: true
        },
        birth_weight: {
            type: _sequelize.default.DECIMAL,
            allowNull: true
        },
        birth_length: {
            type: _sequelize.default.DECIMAL,
            allowNull: true
        },
        birth_delivery_type: {
            type: _sequelize.default.STRING,
            allowNull: true
        },
        gestational_age_estimate: {
            type: _sequelize.default.INTEGER,
            allowNull: true
        },
        apgar_score_one_minute: {
            type: _sequelize.default.INTEGER,
            allowNull: true
        },
        apgar_score_five_minutes: {
            type: _sequelize.default.INTEGER,
            allowNull: true
        },
        apgar_score_ten_minutes: {
            type: _sequelize.default.INTEGER,
            allowNull: true
        },
        time_of_birth: {
            type: _sequelize.default.STRING,
            allowNull: true
        },
        clinician_at_birth_id: {
            type: _sequelize.default.STRING,
            references: {
                model: 'users',
                key: 'id'
            },
            allowNull: true
        },
        birth_type: {
            type: _sequelize.default.STRING,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('patient_birth_data');
}

//# sourceMappingURL=087_addPatientBirthDataTable.js.map