"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('note_items', {
        id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.UUIDV4
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        note_page_id: {
            type: _sequelize.default.UUID,
            references: {
                model: 'note_pages',
                key: 'id'
            },
            allowNull: false
        },
        revised_by_id: {
            type: _sequelize.default.STRING,
            allowNull: true
        },
        author_id: {
            type: _sequelize.default.STRING,
            references: {
                model: 'users',
                key: 'id'
            },
            allowNull: true
        },
        on_behalf_of_id: {
            type: _sequelize.default.STRING,
            references: {
                model: 'users',
                key: 'id'
            },
            allowNull: true
        },
        content: {
            type: _sequelize.default.TEXT,
            allowNull: false,
            defaultValue: ''
        },
        date: {
            type: _sequelize.default.DATE,
            allowNull: false,
            defaultValue: _sequelize.default.NOW
        }
    });
}
async function down(query) {
    await query.dropTable('note_items');
}

//# sourceMappingURL=091_addNoteItemsTable.js.map