"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
const ISO9075_DATE_FMT = 'YYYY-MM-DD';
// Date time table columns that have been migrated so far (excluding lab requests)
const dateTimeTableColumns = {
    patients: [
        'date_of_death'
    ],
    appointments: [
        'start_time',
        'end_time'
    ],
    triages: [
        'arrival_time',
        'triage_time',
        'closed_time'
    ]
};
// Date table columns that have been migrated so far
const dateTableColumns = {
    invoice_line_items: [
        'date_generated'
    ],
    invoices: [
        'date'
    ],
    invoice_price_change_items: [
        'date'
    ],
    patient_death_data: [
        'external_cause_date',
        'last_surgery_date'
    ]
};
const allColumns = [
    ...Object.entries(dateTimeTableColumns),
    ...Object.entries(dateTableColumns)
];
async function up(query) {
    let count = 0;
    for (const [tableName, columns] of allColumns){
        const where = columns.map((col)=>`${col}_legacy IS NOT NULL`).join(' OR ');
        const countResult = await query.sequelize.query(`SELECT COUNT(*) FROM ${tableName} WHERE ${where};`, {
            type: _sequelize.QueryTypes.SELECT
        });
        count += parseInt(countResult[0].count);
    }
    // If there is no legacy column data, then we don't need to run the migration or check
    // for the timezone in the config
    if (count === 0) {
        return;
    }
    const COUNTRY_TIMEZONE = _config.default?.countryTimeZone;
    if (!COUNTRY_TIMEZONE) {
        throw Error('A countryTimeZone must be configured in local.json5 for this migration to run.');
    }
    const promises = [];
    // Migrate date_time_string columns
    // only include data that still matches the legacy column
    Object.entries(dateTimeTableColumns).forEach(([tableName, columns])=>{
        columns.forEach((columnName)=>{
            promises.push(query.sequelize.query(`UPDATE ${tableName}
           SET ${columnName} = TO_CHAR(${columnName}_legacy::TIMESTAMPTZ AT TIME ZONE '${COUNTRY_TIMEZONE}', :dateTimeFmt)
           WHERE ${columnName} = TO_CHAR(${columnName}_legacy::TIMESTAMPTZ AT TIME ZONE 'UTC', :dateTimeFmt);
        `, {
                replacements: {
                    dateTimeFmt: ISO9075_DATE_TIME_FMT
                }
            }));
        });
    });
    // Migrate date_string columns
    // only include data that still matches the legacy column
    Object.entries(dateTableColumns).forEach(([tableName, columns])=>{
        columns.forEach((columnName)=>{
            promises.push(query.sequelize.query(`UPDATE ${tableName}
           SET ${columnName} = TO_CHAR(${columnName}_legacy::TIMESTAMPTZ AT TIME ZONE '${COUNTRY_TIMEZONE}', :dateFmt)
           WHERE ${columnName} = TO_CHAR(${columnName}_legacy::TIMESTAMPTZ AT TIME ZONE 'UTC', :dateFmt);
        `, {
                replacements: {
                    dateFmt: ISO9075_DATE_FMT
                }
            }));
        });
    });
    await Promise.all(promises);
}
async function down() {
    // No down as is a data correction
    return null;
}

//# sourceMappingURL=098_reMigrateDatesUsingCountryTimezone.js.map