"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.addColumn('imaging_requests', 'priority', {
        type: _sequelize.default.STRING,
        allowNull: true
    });
    await query.sequelize.query(`
    UPDATE imaging_requests
    SET priority = 'urgent'
    WHERE urgent IS TRUE;
  `);
    await query.sequelize.query(`
    UPDATE imaging_requests
    SET priority = 'routine'
    WHERE urgent IS FALSE;
  `);
    await query.removeColumn('imaging_requests', 'urgent');
}
async function down(query) {
    await query.addColumn('imaging_requests', 'urgent', {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: false
    });
    await query.sequelize.query(`
    UPDATE imaging_requests
    SET urgent = TRUE
    WHERE priority = 'urgent';
  `);
    await query.sequelize.query(`
    UPDATE imaging_requests
    SET urgent = FALSE
    WHERE priority = 'routine';
  `);
    await query.removeColumn('imaging_requests', 'priority');
}

//# sourceMappingURL=117_migrateImagingUrgentColumnToPriorityColumn.js.map