"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const _default = {
    up: async (query)=>{
        const isFacility = !!(0, _selectFacilityIds.selectFacilityIds)(_config.default);
        await query.createTable('patient_facilities', {
            // For patient_facilities, we use a composite primary key of patient_id plus facility_id,
            // so that if two users on different devices mark the same patient for sync, the join
            // record is treated as the same record, making the sync merge strategy trivial
            // id is still produced, but just as a deterministically generated convenience column for
            // consistency and to maintain the assumption of "id" existing in various places
            // N.B. because ';' is used to join the two, we replace any actual occurrence of ';' with ':'
            // to avoid clashes on the joined id
            id: {
                type: `TEXT GENERATED ALWAYS AS (REPLACE("patient_id", ';', ':') || ';' || REPLACE("facility_id", ';', ':')) STORED`
            },
            created_at: {
                type: _sequelize.default.DATE,
                defaultValue: _sequelize.default.NOW
            },
            updated_at: {
                type: _sequelize.default.DATE,
                defaultValue: _sequelize.default.NOW
            },
            deleted_at: {
                type: _sequelize.default.DATE,
                defaultValue: _sequelize.default.NOW
            },
            facility_id: {
                type: _sequelize.default.STRING,
                primaryKey: true,
                references: {
                    model: 'facilities',
                    key: 'id'
                }
            },
            patient_id: {
                type: _sequelize.default.STRING,
                primaryKey: true,
                references: {
                    model: 'patients',
                    key: 'id'
                }
            },
            // add updated_at_sync_tick explicitly rather than relying on the post-migration step,
            // as we need to manually set the patient_facilities records to be included in the first
            // push up to the central server after upgrading to the new sync model
            updated_at_sync_tick: {
                type: _sequelize.default.BIGINT,
                defaultValue: isFacility ? -999 : 0
            }
        }, {
            uniqueKeys: {
                patient_facility_unique: {
                    fields: [
                        'patient_id',
                        'facility_id'
                    ]
                }
            }
        });
    },
    down: async (query)=>{
        await query.dropTable('patient_facilities');
    }
};

//# sourceMappingURL=125_createFacilityPatientSyncTable.js.map