"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function up(query) {
    await query.bulkDelete('patient_additional_data', {
        merged_into_id: {
            [_sequelize.Op.not]: null
        }
    }); // this bit destructive, can't be downed
    await query.removeColumn('patient_additional_data', 'merged_into_id');
    await query.sequelize.query(`
    ALTER TABLE patient_additional_data DROP CONSTRAINT patient_additional_data_pkey;
    ALTER TABLE patient_additional_data ADD PRIMARY KEY (patient_id);
  `);
    await query.removeColumn('patient_additional_data', 'id');
    await query.addColumn('patient_additional_data', 'id', {
        type: `TEXT GENERATED ALWAYS AS ("patient_id") STORED`
    });
}
async function down(query) {
    await query.removeColumn('patient_additional_data', 'id');
    await query.addColumn('patient_additional_data', 'id', {
        type: _sequelize.default.TEXT,
        allowNull: false,
        defaultValue: _sequelize.default.UUIDV4
    });
    await query.sequelize.query(`
    ALTER TABLE patient_additional_data DROP CONSTRAINT patient_additional_data_pkey;
    ALTER TABLE patient_additional_data ADD PRIMARY KEY (id);
  `);
    await query.addColumn('patient_additional_data', 'merged_into_id', {
        type: _sequelize.default.TEXT,
        allowNull: true
    });
}

//# sourceMappingURL=130_usePatientIdPrimaryKeyPAD.js.map