"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const TABLE = {
    schema: 'fhir',
    tableName: 'diagnostic_reports'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        last_updated: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        extension: {
            type: 'fhir.extension[]',
            allowNull: false,
            defaultValue: '{}'
        },
        identifier: {
            type: 'fhir.identifier[]',
            allowNull: false,
            defaultValue: '{}'
        },
        status: {
            type: _sequelize.default.TEXT,
            allowNull: false
        },
        code: {
            type: 'fhir.codeable_concept',
            allowNull: false
        },
        subject: {
            type: 'fhir.reference',
            allowNull: true
        },
        effective_date_time: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        issued: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        performer: {
            type: 'fhir.reference[]',
            allowNull: false,
            defaultValue: '{}'
        },
        result: {
            type: 'fhir.reference[]',
            allowNull: false,
            defaultValue: '{}'
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ]);
    await query.sequelize.query(`
    CREATE TRIGGER versioning BEFORE UPDATE ON fhir.${TABLE.tableName}
    FOR EACH ROW EXECUTE FUNCTION fhir.trigger_versioning()
  `);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=149_fhirDiagnosticReportTable.js.map