// Migrate surveys using reference data with type 'department' to use dedicated department table
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    UPDATE survey_screen_components
    SET config = jsonb_set(
      config::jsonb,
      '{source}',
      CASE
        config::jsonb -> 'where' ->> 'type'
        WHEN 'department' THEN '"Department"'
        WHEN 'facility' THEN '"Facility"'
        WHEN 'location' THEN '"Location"'
      END::jsonb
    ) - 'where'
  WHERE
    config <> ''
    AND config::jsonb ->> 'source' = 'ReferenceData'
    AND config::jsonb -> 'where' ->> 'type' in (
      'department',
      'facility',
      'location'
    )
  `);
}
async function down() {
// No down migration
}

//# sourceMappingURL=1669679414865-updateLegacyDepartmentReferencesSurveyScreenComponents.js.map