"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const tables = [
    'patient_death_data',
    'note_pages'
];
async function up(query) {
    for (const table of tables){
        await query.addColumn(table, 'visibility_status', {
            type: _sequelize.DataTypes.TEXT,
            defaultValue: 'current'
        });
    }
}
async function down(query) {
    for (const table of tables){
        await query.removeColumn(table, 'visibility_status');
    }
}

//# sourceMappingURL=1676591314361-addVisibilityStatusToNotesAndDeathData.js.map