"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('patient_letter_templates', {
        id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        deleted_at: {
            type: _sequelize.default.DATE
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3)
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3)
        },
        name: {
            type: _sequelize.default.TEXT,
            allowNull: false
        },
        date_created: {
            type: 'date_string'
        },
        title: {
            type: _sequelize.default.TEXT
        },
        body: {
            type: _sequelize.default.TEXT
        },
        visibility_status: {
            type: _sequelize.default.TEXT,
            defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
        },
        created_by_id: {
            type: _sequelize.default.STRING,
            references: {
                model: 'users',
                key: 'id'
            }
        }
    });
}
async function down(query) {
    await query.dropTable('patient_letter_templates');
}

//# sourceMappingURL=1679271355192-addPatientLetterTemplateTable.js.map