"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function up(query) {
    const dupes = await query.sequelize.query(`
    SELECT COUNT(*), code 
    FROM locations
    GROUP BY code
    HAVING COUNT(*) > 1
  `, {
        type: _sequelize.QueryTypes.SELECT
    });
    if (dupes.length > 0) {
        const codes = dupes.map((d)=>`"${d.code}" (x${d.count})`).join(',');
        throw new Error(`Found some Locations in the db that have the same code as each other. Please resolve the duplication before proceeding.\nThe duplicated codes are: ${codes}`);
    }
    await query.changeColumn('locations', 'code', {
        type: _sequelize.default.STRING,
        allowNull: false,
        unique: true
    });
}
async function down(query) {
    await query.changeColumn('locations', 'code', {
        type: _sequelize.default.STRING,
        allowNull: false,
        unique: false
    });
}

//# sourceMappingURL=1679627805922-uniqueLocationCodes.js.map