"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.dropTable('lab_test_panel_external_codes');
}
async function down(query) {
    await query.createTable('lab_test_panel_external_codes', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        visibility_status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: 'current'
        },
        lab_test_panel_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            unique: true,
            references: {
                model: 'lab_test_panels',
                key: 'id'
            }
        },
        code: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        description: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        }
    });
}

//# sourceMappingURL=1681416693163-removeLabTestPanelExternalCodesTable.js.map