"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    const counts = await query.sequelize.query('SELECT COUNT(*) as userCount FROM "users"', {
        type: _sequelize.QueryTypes.SELECT
    });
    // if there are no users, provisioning will take care of it
    // if there are users, this is an existing install, so create a system user
    if (counts[0].userCount > 0) {
        await query.sequelize.query(`
      INSERT INTO "users"
      (id, email, created_at, updated_at, display_name, role)
      VALUES
      (uuid_nil(), 'system', NOW(), NOW(), 'System', 'admin')
      ON CONFLICT (id) DO NOTHING;
    `);
    }
}
async function down() {
// the up migration is idempotent and we also cannot know whether there
// existed a system user before, so we can't safely revert anything
}

//# sourceMappingURL=1685403132663-systemUser.js.map