"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.removeColumn('notes', 'revised_by_id');
    await query.addColumn('notes', 'revised_by_id', {
        type: _sequelize.default.UUID,
        references: {
            model: 'notes',
            key: 'id'
        },
        allowNull: true
    });
}
async function down(query) {
    await query.removeConstraint('notes', 'notes_revised_by_id_fkey');
    await query.removeColumn('notes', 'revised_by_id');
    await query.addColumn('notes', 'revised_by_id', {
        type: _sequelize.default.STRING,
        allowNull: true
    });
}

//# sourceMappingURL=1686114022271-changeNotesRevisedByIdToUuid.js.map