"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    NON_DETERMINISTIC: function() {
        return NON_DETERMINISTIC;
    },
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const NON_DETERMINISTIC = true;
const TABLE = {
    schema: 'fhir',
    tableName: 'organizations'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        last_updated: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        identifier: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: true
        },
        name: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        active: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: true
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ], {
        unique: true
    });
    await query.sequelize.query(`
    CREATE TRIGGER versioning BEFORE UPDATE ON fhir.${TABLE.tableName}
    FOR EACH ROW EXECUTE FUNCTION fhir.trigger_versioning()
  `);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1708090724699-fhirOrganizationFacility.js.map