/* eslint-disable no-unused-vars */ // remove the above line
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function up(query) {
    await query.createTable('reference_data_relations', {
        id: {
            type: _sequelize.DataTypes.UUID,
            defaultValue: _sequelize.default.fn('uuid_generate_v4'),
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        reference_data_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        reference_data_parent_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        }
    }, {
        uniqueKeys: {
            reference_data_id_type: {
                fields: [
                    'reference_data_id',
                    'type'
                ]
            }
        },
        indexes: [
            {
                name: 'reference_data_relations_reference_data_id_index',
                fields: [
                    'reference_data_id'
                ]
            },
            {
                name: 'reference_data_relations_parent_relation_id_index',
                fields: [
                    'parent_relation_id'
                ]
            },
            {
                name: 'reference_data_relations_type_index',
                fields: [
                    'type'
                ]
            }
        ]
    });
}
async function down(query) {
    await query.dropTable('reference_data_relations', {});
}

//# sourceMappingURL=1709588580194-addReferenceDataRelationTable.js.map