"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('patient_additional_data', 'health_center_id', {
        type: _sequelize.DataTypes.TEXT,
        references: {
            model: 'facilities',
            key: 'id'
        },
        allowNull: true
    });
    await query.addIndex('patient_additional_data', [
        'health_center_id'
    ]);
}
async function down(query) {
    await query.removeColumn('patient_additional_data', 'health_center_id');
}

//# sourceMappingURL=1712274676172-addHealthCenterIdToPatientAdditionalData.js.map