"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('sync_sessions', 'errors', {
        type: _sequelize.DataTypes.ARRAY(_sequelize.DataTypes.TEXT),
        allowNull: true
    });
    await query.sequelize.query(`
    UPDATE sync_sessions SET errors = ARRAY[error]
    WHERE error IS NOT NULL;
  `);
    await query.removeColumn('sync_sessions', 'error');
}
async function down(query) {
    await query.addColumn('sync_sessions', 'error', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: true
    });
    await query.sequelize.query(`
    UPDATE sync_sessions SET error = errors[1]
    WHERE errors IS NOT NULL;
  `);
    await query.removeColumn('sync_sessions', 'errors');
}

//# sourceMappingURL=1723105504782-alterSyncSessionErrorColumnToBeArray.js.map