"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION adjusted_offset()
    RETURNS interval AS $$
      BEGIN
        RETURN local_system_fact('${_constants.FACT_TIME_OFFSET}', '0 microseconds')::interval;
      END;
    $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION adjusted_timestamp()
    RETURNS timestamptz AS $$
      BEGIN
        RETURN current_timestamp + adjusted_offset();
      END;
    $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
  `);
}
async function down(query) {
    await query.sequelize.query('DROP FUNCTION adjusted_timestamp CASCADE');
    await query.sequelize.query('DROP FUNCTION adjusted_offset CASCADE');
}

//# sourceMappingURL=1739968205110-addAdjustedTimestampFunction.js.map