"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'logs',
    tableName: 'changes'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        table_oid: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: false
        },
        table_schema: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        table_name: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        logged_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('adjusted_timestamp')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        updated_by_user_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: {
                    schema: 'public',
                    tableName: 'users'
                },
                key: 'id'
            }
        },
        device_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('local_system_fact', _constants.FACT_DEVICE_ID, 'unknown')
        },
        version: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('local_system_fact', _constants.FACT_CURRENT_VERSION, 'unknown')
        },
        record_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        record_update: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false
        },
        record_created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        record_updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        record_deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        record_sync_tick: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false
        },
        record_data: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false
        }
    });
    await query.addIndex(TABLE, [
        'table_oid'
    ], {
        using: 'hash'
    });
    await query.addIndex(TABLE, [
        'record_id'
    ], {
        using: 'hash'
    });
    await query.addIndex(TABLE, [
        'device_id'
    ], {
        using: 'hash'
    });
    await query.addIndex(TABLE, [
        'updated_by_user_id'
    ], {
        using: 'hash'
    });
    await query.addIndex(TABLE, [
        'logged_at'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'version'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'record_created_at'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'record_updated_at'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'record_deleted_at'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'record_sync_tick'
    ], {
        using: 'btree'
    });
    await query.addIndex(TABLE, [
        'record_data'
    ], {
        using: 'gin'
    });
    await query.sequelize.query(`CREATE INDEX changes_table_name ON logs.changes USING HASH ((table_schema || '.' || table_name))`);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1739968205114-createChangelogsTable.js.map