"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('portal_survey_assignments', 'facility_id', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: false,
        references: {
            model: 'facilities',
            key: 'id'
        }
    });
    // Add index for facility_id to improve query performance
    await query.addIndex('portal_survey_assignments', [
        'facility_id'
    ], {
        name: 'idx_portal_survey_assignments_facility_id'
    });
}
async function down(query) {
    await query.removeIndex('portal_survey_assignments', 'idx_portal_survey_assignments_facility_id');
    await query.removeColumn('portal_survey_assignments', 'facility_id');
}

//# sourceMappingURL=1752638174401-addFacilityIdToPortalSurveyAssignments.js.map