"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function checkIsFreshDeployment(query) {
    const [hasUpdatedAtSyncTick] = await query.sequelize.query(`
    SELECT EXISTS (SELECT TRUE
    FROM information_schema.columns
    WHERE table_schema = 'public' AND table_name = 'patient_program_registrations' AND column_name = 'updated_at_sync_tick');
  `);
    // If the patient_program_registrations table does not have the updated_at_sync_tick column it means this is
    // the first time deploying the server. If that's the case, we can skip the migration.
    // @ts-ignore
    return !hasUpdatedAtSyncTick?.[0]?.exists;
}
async function up(query) {
    const isFacility = Boolean((0, _selectFacilityIds.selectFacilityIds)(_config.default));
    if (isFacility) {
        return;
    }
    const isFreshDeployment = await checkIsFreshDeployment(query);
    // If the patient_program_registrations table does not have the updated_at_sync_tick column it means this is
    // the first time deploying the server. If that's the case, we can skip the migration.
    if (isFreshDeployment) {
        return;
    }
    // Update updated_at_sync_tick for patient_program_registrations
    await query.sequelize.query(`
    UPDATE patient_program_registrations
    SET updated_at_sync_tick = (SELECT CAST(value AS bigint) FROM local_system_facts WHERE key = 'currentSyncTick')
  `);
    // Update updated_at_sync_tick for patient_program_registration_conditions
    await query.sequelize.query(`
    UPDATE patient_program_registration_conditions
    SET updated_at_sync_tick = (SELECT CAST(value AS bigint) FROM local_system_facts WHERE key = 'currentSyncTick')
  `);
    // Delete records from sync_lookup table
    await query.sequelize.query(`
    DELETE FROM sync_lookup
    WHERE record_type IN ('patient_program_registrations', 'patient_program_registration_conditions')
  `);
}
async function down() {
// Note: This migration cannot be easily reversed as we're updating existing data
// and deleting records.
}

//# sourceMappingURL=1754351568045-fullyResyncPatientProgramRegistrationsAndConditions.js.map