"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
async function up(query) {
    await query.changeColumn('location_groups', 'is_bookable', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false,
        defaultValue: _constants.LOCATION_BOOKABLE_VIEW.NO
    });
    await query.sequelize.query(`
    UPDATE location_groups 
    SET is_bookable = CASE 
      WHEN is_bookable = 'true' THEN '${_constants.LOCATION_BOOKABLE_VIEW.ALL}'
      ELSE '${_constants.LOCATION_BOOKABLE_VIEW.NO}'
    END
  `);
}
async function down(query) {
    await query.sequelize.query(`
    UPDATE location_groups 
    SET is_bookable = CASE 
        WHEN is_bookable = 'no' THEN 'false'
        ELSE 'true'
    END
  `);
    await query.sequelize.query(`
    ALTER TABLE location_groups 
    ALTER COLUMN is_bookable TYPE boolean USING is_bookable::boolean,
    ALTER COLUMN is_bookable SET NOT NULL,
    ALTER COLUMN is_bookable SET DEFAULT false;
  `);
}

//# sourceMappingURL=1754377094732-changeIsBookableToString.js.map